<?php
if (!defined('ABSPATH')) {
    exit;
}

/**
 * Class OSF_Custom_Post_Type_Footer
 */
class OSF_Custom_Post_Type_Footer extends OSF_Custom_Post_Type_Abstract
{

    /**
     * @return void
     */
    public function create_post_type()
    {

        $labels = array(
            'name'               => __('Footer', "startor-core"),
            'singular_name'      => __('Footer', "startor-core"),
            'add_new'            => __('Add New Footer', "startor-core"),
            'add_new_item'       => __('Add New Footer', "startor-core"),
            'edit_item'          => __('Edit Footer', "startor-core"),
            'new_item'           => __('New Footer', "startor-core"),
            'view_item'          => __('View Footer', "startor-core"),
            'search_items'       => __('Search Footers', "startor-core"),
            'not_found'          => __('No Footers found', "startor-core"),
            'not_found_in_trash' => __('No Footers found in Trash', "startor-core"),
            'parent_item_colon'  => __('Parent Footer:', "startor-core"),
            'menu_name'          => __('Footer Builder', "startor-core"),
        );

        $args = array(
            'labels'              => $labels,
            'hierarchical'        => true,
            'description'         => __('List Footer', "startor-core"),
            'supports'            => array('title', 'editor', 'thumbnail'), //page-attributes, post-formats
            'public'              => true,
            'show_ui'             => true,
            'show_in_menu'        => true,
            'menu_position'       => 5,
            'menu_icon'           => $this->get_icon(__FILE__),
            'show_in_nav_menus'   => false,
            'publicly_queryable'  => true,
            'exclude_from_search' => true,
            'has_archive'         => true,
            'query_var'           => true,
            'can_export'          => true,
            'rewrite'             => true,
            'capability_type'     => 'post'
        );
        register_post_type('footer', $args);
    }


}

new OSF_Custom_Post_Type_Footer;