/*!
* universal-tilt.js v1.0.6
* Created 2018 by Jakub Biesiada
* Original idea: https://github.com/gijsroge/tilt.js
* MIT License
*/
class UniversalTilt{constructor(e,t={}){e.length>0?this.init(e,t):0!==e.length&&(this.element=e,this.width=null,this.height=null,this.left=null,this.top=null,this.timeout=null,this.settings=this.settings(t),this.reverse=this.settings.reverse?-1:1,this.settings.shine&&this.shine(),this.element.style.transform=`perspective(${this.settings.perspective}px)`,this.addEventListeners())}init(e,t){for(let i=0;i<e.length;i++)this.universalTilt=new UniversalTilt(e[i],t)}isMobile(){if(window.DeviceMotionEvent&&"ontouchstart"in document.documentElement&&this.settings.mobile)return!0}addEventListeners(){this.isMobile()?window.addEventListener("devicemotion",e=>this.onDeviceMove(e)):("element"===this.settings["position-base"]?this.base=this.element:"window"===this.settings["position-base"]&&(this.base=window),this.base.addEventListener("mouseenter",e=>this.onMouseEnter(e)),this.base.addEventListener("mousemove",e=>this.onMouseMove(e)),this.base.addEventListener("mouseleave",e=>this.onMouseLeave(e)))}onMouseEnter(e){this.updateElementPosition(),this.transitions(),"function"==typeof this.settings.onMouseEnter&&this.settings.onMouseEnter(this.element)}onMouseMove(e){this.event=e,this.updateElementPosition(),window.requestAnimationFrame(()=>this.update()),"function"==typeof this.settings.onMouseMove&&this.settings.onMouseMove(this.element)}onMouseLeave(e){this.transitions(),window.requestAnimationFrame(()=>this.reset()),"function"==typeof this.settings.onMouseLeave&&this.settings.onMouseLeave(this.element)}onDeviceMove(e){this.update(),this.updateElementPosition(),this.transitions(),"function"==typeof this.settings.onDeviceMove&&this.settings.onDeviceMove(this.element)}reset(){this.event={pageX:this.left+this.width/2,pageY:this.top+this.height/2},this.settings.reset&&(this.element.style.transform=`perspective(${this.settings.perspective}px) rotateX(0deg) rotateY(0deg) scale3d(1, 1, 1)`),this.settings.shine&&!this.settings["shine-save"]&&Object.assign(this.shineElement.style,{transform:"rotate(180deg) translate3d(-50%, -50%, 0)",opacity:"0"})}getValues(){let e,t;if(this.isMobile()){let i,s;e=event.accelerationIncludingGravity.x/4,t=event.accelerationIncludingGravity.y/4,90===window.orientation?(s=(1-t)/2,t=i=(1+e)/2,e=s):-90===window.orientation?(s=(1+t)/2,t=i=(1-e)/2,e=s):0===window.orientation?(t=s=(1+t)/2,e=i=(1+e)/2):180===window.orientation&&(t=s=(1-t)/2,e=i=(1-e)/2)}else"element"===this.settings["position-base"]?(e=(this.event.clientX-this.left)/this.width,t=(this.event.clientY-this.top)/this.height):"window"===this.settings["position-base"]&&(e=this.event.clientX/window.innerWidth,t=this.event.clientY/window.innerHeight);e=Math.min(Math.max(e,0),1),t=Math.min(Math.max(t,0),1);let i=(this.settings.max/2-e*this.settings.max).toFixed(2),s=(t*this.settings.max-this.settings.max/2).toFixed(2),n=Math.atan2(e-.5,.5-t)*(180/Math.PI);return{tiltX:this.reverse*i,tiltY:this.reverse*s,angle:n}}updateElementPosition(){let e=this.element.getBoundingClientRect();this.width=this.element.offsetWidth,this.height=this.element.offsetHeight,this.left=e.left,this.top=e.top}update(){let e=this.getValues();this.element.style.transform=`perspective(${this.settings.perspective}px)\n     rotateX(${this.settings.disabled&&"X"===this.settings.disabled.toUpperCase()?0:e.tiltY}deg)\n     rotateY(${this.settings.disabled&&"Y"===this.settings.disabled.toUpperCase()?0:e.tiltX}deg)\n     scale3d(${this.settings.scale}, ${this.settings.scale}, ${this.settings.scale})`,this.settings.shine&&Object.assign(this.shineElement.style,{transform:`rotate(${e.angle}deg) translate3d(-50%, -50%, 0)`,opacity:`${this.settings["shine-opacity"]}`}),this.element.dispatchEvent(new CustomEvent("tiltChange",{detail:e}))}shine(){const e=document.createElement("div");e.classList.add("shine");const t=document.createElement("div");t.classList.add("shine-inner"),e.appendChild(t),this.element.appendChild(e),this.shineWrapper=this.element.querySelector(".shine"),this.shineElement=this.element.querySelector(".shine-inner"),Object.assign(this.shineWrapper.style,{position:"absolute",top:"0",left:"0",height:"100%",width:"100%",overflow:"hidden"}),Object.assign(this.shineElement.style,{position:"absolute",top:"50%",left:"50%","pointer-events":"none","background-image":"linear-gradient(0deg, rgba(255,255,255,0) 0%, rgba(255,255,255,1) 100%)",width:`${2*this.element.offsetWidth}px`,height:`${2*this.element.offsetWidth}px`,transform:"rotate(180deg) translate3d(-50%, -50%, 0)","transform-origin":"0% 0%",opacity:"0"})}transitions(){clearTimeout(this.timeout),this.element.style.transition=`all ${this.settings.speed}ms ${this.settings.easing}`,this.settings.shine&&(this.shineElement.style.transition=`opacity ${this.settings.speed}ms ${this.settings.easing}`),this.timeout=setTimeout(()=>{this.element.style.transition="",this.settings.shine&&(this.shineElement.style.transition="")},this.settings.speed)}settings(e){let t={"position-base":"element",reset:!0,mobile:!0,shine:!1,"shine-opacity":0,"shine-save":!1,max:35,perspective:1e3,scale:1,disabled:null,reverse:!1,speed:300,easing:"cubic-bezier(.03,.98,.52,.99)",onMouseEnter:null,onMouseMove:null,onMouseLeave:null,onDeviceMove:null},i={};for(let s in t)if(s in e)i[s]=e[s];else if(this.element.getAttribute(`data-${s}`)){let e=this.element.getAttribute(`data-${s}`);try{i[s]=JSON.parse(e)}catch(t){i[s]=e}}else i[s]=t[s];return i}}let scope;if("undefined"!=typeof document&&new UniversalTilt(document.querySelectorAll("[data-tilt]")),"undefined"!=typeof window?scope=window:"undefined"!=typeof global&&(scope=global),scope&&scope.jQuery){scope.jQuery.fn.universalTilt=function(e){new UniversalTilt(this,e)}}"function"==typeof define&&define.amd?define("UniversalTilt",[],function(){return UniversalTilt}):"undefined"==typeof exports||exports.nodeType||("undefined"!=typeof module&&!module.nodeType&&module.exports&&(exports=module.exports=UniversalTilt),exports.default=UniversalTilt);